# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from ..sdproperty import SDProperty
from ..sdnode import SDNode
from ..sdapiobject import SDAPIObject
from ..sdproperty import SDPropertyCategory
from ..sdproperty import SDPropertyInheritanceMethod
from ..sdapiobject import SDApiError
from ..apiexception import APIException

class SDSBSCompNode(SDNode):
    """
    Class managing a Substance compositing node
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDSBSCompNode
        """
        super(SDSBSCompNode, self).__init__(APIContext, handle, *args, **kwargs)

    def getPropertyInheritanceMethod(self, sdProperty : SDProperty) -> SDPropertyInheritanceMethod:
        """
        For properties that support it, get the inheritance method of the specified property

        :param sdProperty: The property from which to get the inheritance method
        """
        outInheritanceMethod = ctypes.c_int()
        _res = self.mAPIContext.SDSBSCompNode_getPropertyInheritanceMethod(self.mHandle, sdProperty.mHandle, ctypes.byref(outInheritanceMethod))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return SDPropertyInheritanceMethod(outInheritanceMethod.value)

    def getInputPropertyInheritanceMethodFromId(self, sdPropertyId : str) -> SDPropertyInheritanceMethod:
        """
        For input properties that support it, get the inheritance method of the specified property from its Id

        :param sdPropertyId: The Id of the input property for which to set the inheritance method
        """
        outInheritanceMethod = ctypes.c_int()
        _res = self.mAPIContext.SDSBSCompNode_getInputPropertyInheritanceMethodFromId(self.mHandle, ctypes.create_string_buffer(sdPropertyId.encode('utf-8')), ctypes.byref(outInheritanceMethod))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return SDPropertyInheritanceMethod(outInheritanceMethod.value)

    def setPropertyInheritanceMethod(self, sdProperty : SDProperty, inheritanceMethod : SDPropertyInheritanceMethod) -> None:
        """
        For properties that support it, set the inheritance method of the specified property

        :param sdProperty: The property for which to set the inheritance method
        :param inheritanceMethod: The inheritance method to set on the property
        """
        _res = self.mAPIContext.SDSBSCompNode_setPropertyInheritanceMethod(self.mHandle, sdProperty.mHandle, inheritanceMethod.value)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def setInputPropertyInheritanceMethodFromId(self, sdPropertyId : str, inheritanceMethod : SDPropertyInheritanceMethod) -> None:
        """
        For input properties that support it, set the inheritance method of the specified property from its Id

        :param sdPropertyId: The Id of the input property for which to set the inheritance method
        :param inheritanceMethod: The inheritance method to set on the property
        """
        _res = self.mAPIContext.SDSBSCompNode_setInputPropertyInheritanceMethodFromId(self.mHandle, ctypes.create_string_buffer(sdPropertyId.encode('utf-8')), inheritanceMethod.value)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

